package com.xforceplus.studygaoyonglei.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studygaoyonglei.entity.Bgytest;
import com.xforceplus.studygaoyonglei.service.IBgytestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class BgytestController {

  @Autowired
  private IBgytestService bgytestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bgytest ${table.comment}
   * @return
   */
  @GetMapping("/bgytests" )
  public XfR getBgytests(XfPage page, Bgytest bgytest) {
    return XfR.ok(bgytestServiceImpl.page(page, Wrappers.query(bgytest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bgytests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bgytestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bgytest ${table.comment}
   * @return XfR
   */
  @PostMapping("/bgytests")
  public XfR save(@RequestBody Bgytest bgytest) {
     return XfR.ok(bgytestServiceImpl.save(bgytest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bgytest ${table.comment}
   * @return XfR
   */
  @PutMapping("/bgytests/{id}")
  public XfR putUpdate(@RequestBody Bgytest bgytest,@PathVariable Long id) {
      bgytest.setId(id);
      return XfR.ok(bgytestServiceImpl.updateById(bgytest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bgytest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bgytests/{id}")
  public XfR patchUpdate(@RequestBody Bgytest bgytest,@PathVariable Long id) {
      Bgytest upbgytest = bgytestServiceImpl.getById(id);
      if(upbgytest != null){
        upbgytest = ObjectCopyUtils.copyProperties(bgytest,upbgytest,true);
      }
      return XfR.ok(bgytestServiceImpl.updateById(upbgytest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bgytests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bgytestServiceImpl.removeById(id));
  }

  @PostMapping("/bgytests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bgytest");
     params.put("request", condition);

     return XfR.ok(bgytestServiceImpl.querys(params));
  }

}
