package com.xforceplus.studygaoyonglei.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studygaoyonglei.entity.Bgytestdetail;
import com.xforceplus.studygaoyonglei.service.IBgytestdetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class BgytestdetailController {

  @Autowired
  private IBgytestdetailService bgytestdetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bgytestdetail ${table.comment}
   * @return
   */
  @GetMapping("/bgytestdetails" )
  public XfR getBgytestdetails(XfPage page, Bgytestdetail bgytestdetail) {
    return XfR.ok(bgytestdetailServiceImpl.page(page, Wrappers.query(bgytestdetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bgytestdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bgytestdetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bgytestdetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/bgytestdetails")
  public XfR save(@RequestBody Bgytestdetail bgytestdetail) {
     return XfR.ok(bgytestdetailServiceImpl.save(bgytestdetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bgytestdetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/bgytestdetails/{id}")
  public XfR putUpdate(@RequestBody Bgytestdetail bgytestdetail,@PathVariable Long id) {
      bgytestdetail.setId(id);
      return XfR.ok(bgytestdetailServiceImpl.updateById(bgytestdetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bgytestdetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bgytestdetails/{id}")
  public XfR patchUpdate(@RequestBody Bgytestdetail bgytestdetail,@PathVariable Long id) {
      Bgytestdetail upbgytestdetail = bgytestdetailServiceImpl.getById(id);
      if(upbgytestdetail != null){
        upbgytestdetail = ObjectCopyUtils.copyProperties(bgytestdetail,upbgytestdetail,true);
      }
      return XfR.ok(bgytestdetailServiceImpl.updateById(upbgytestdetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bgytestdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bgytestdetailServiceImpl.removeById(id));
  }

  @PostMapping("/bgytestdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bgytestdetail");
     params.put("request", condition);

     return XfR.ok(bgytestdetailServiceImpl.querys(params));
  }

}
