package com.xforceplus.studylanlongliang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studylanlongliang.entity.InvoiceDetails;
import com.xforceplus.studylanlongliang.service.IInvoiceDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-27
 */
@RestController
public class InvoiceDetailsController {

  @Autowired
  private IInvoiceDetailsService invoiceDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceDetails ${table.comment}
   * @return
   */
  @GetMapping("/invoicedetailss" )
  public XfR getInvoiceDetailss(XfPage page, InvoiceDetails invoiceDetails) {
    return XfR.ok(invoiceDetailsServiceImpl.page(page, Wrappers.query(invoiceDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedetailss")
  public XfR save(@RequestBody InvoiceDetails invoiceDetails) {
     return XfR.ok(invoiceDetailsServiceImpl.save(invoiceDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedetailss/{id}")
  public XfR putUpdate(@RequestBody InvoiceDetails invoiceDetails,@PathVariable Long id) {
      invoiceDetails.setId(id);
      return XfR.ok(invoiceDetailsServiceImpl.updateById(invoiceDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedetailss/{id}")
  public XfR patchUpdate(@RequestBody InvoiceDetails invoiceDetails,@PathVariable Long id) {
      InvoiceDetails upinvoiceDetails = invoiceDetailsServiceImpl.getById(id);
      if(upinvoiceDetails != null){
        upinvoiceDetails = ObjectCopyUtils.copyProperties(invoiceDetails,upinvoiceDetails,true);
      }
      return XfR.ok(invoiceDetailsServiceImpl.updateById(upinvoiceDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_details");
     params.put("request", condition);

     return XfR.ok(invoiceDetailsServiceImpl.querys(params));
  }

}
