package com.xforceplus.studymaoyangguang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studymaoyangguang.entity.BizOrderUploadHeader;
import com.xforceplus.studymaoyangguang.service.IBizOrderUploadHeaderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class BizOrderUploadHeaderController {

  @Autowired
  private IBizOrderUploadHeaderService bizOrderUploadHeaderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderUploadHeader ${table.comment}
   * @return
   */
  @GetMapping("/bizorderuploadheaders" )
  public XfR getBizOrderUploadHeaders(XfPage page, BizOrderUploadHeader bizOrderUploadHeader) {
    return XfR.ok(bizOrderUploadHeaderServiceImpl.page(page, Wrappers.query(bizOrderUploadHeader)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderuploadheaders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderUploadHeaderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderUploadHeader ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderuploadheaders")
  public XfR save(@RequestBody BizOrderUploadHeader bizOrderUploadHeader) {
     return XfR.ok(bizOrderUploadHeaderServiceImpl.save(bizOrderUploadHeader));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderUploadHeader ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderuploadheaders/{id}")
  public XfR putUpdate(@RequestBody BizOrderUploadHeader bizOrderUploadHeader,@PathVariable Long id) {
      bizOrderUploadHeader.setId(id);
      return XfR.ok(bizOrderUploadHeaderServiceImpl.updateById(bizOrderUploadHeader));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderUploadHeader ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderuploadheaders/{id}")
  public XfR patchUpdate(@RequestBody BizOrderUploadHeader bizOrderUploadHeader,@PathVariable Long id) {
      BizOrderUploadHeader upbizOrderUploadHeader = bizOrderUploadHeaderServiceImpl.getById(id);
      if(upbizOrderUploadHeader != null){
        upbizOrderUploadHeader = ObjectCopyUtils.copyProperties(bizOrderUploadHeader,upbizOrderUploadHeader,true);
      }
      return XfR.ok(bizOrderUploadHeaderServiceImpl.updateById(upbizOrderUploadHeader));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderuploadheaders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderUploadHeaderServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderuploadheaders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_upload_header");
     params.put("request", condition);

     return XfR.ok(bizOrderUploadHeaderServiceImpl.querys(params));
  }

}
