package com.xforceplus.studymaoyangguang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studymaoyangguang.entity.ExtendedAttrs;
import com.xforceplus.studymaoyangguang.service.IExtendedAttrsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class ExtendedAttrsController {

  @Autowired
  private IExtendedAttrsService extendedAttrsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extendedAttrs ${table.comment}
   * @return
   */
  @GetMapping("/extendedattrss" )
  public XfR getExtendedAttrss(XfPage page, ExtendedAttrs extendedAttrs) {
    return XfR.ok(extendedAttrsServiceImpl.page(page, Wrappers.query(extendedAttrs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/extendedattrss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extendedAttrsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param extendedAttrs ${table.comment}
   * @return XfR
   */
  @PostMapping("/extendedattrss")
  public XfR save(@RequestBody ExtendedAttrs extendedAttrs) {
     return XfR.ok(extendedAttrsServiceImpl.save(extendedAttrs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param extendedAttrs ${table.comment}
   * @return XfR
   */
  @PutMapping("/extendedattrss/{id}")
  public XfR putUpdate(@RequestBody ExtendedAttrs extendedAttrs,@PathVariable Long id) {
      extendedAttrs.setId(id);
      return XfR.ok(extendedAttrsServiceImpl.updateById(extendedAttrs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param extendedAttrs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/extendedattrss/{id}")
  public XfR patchUpdate(@RequestBody ExtendedAttrs extendedAttrs,@PathVariable Long id) {
      ExtendedAttrs upextendedAttrs = extendedAttrsServiceImpl.getById(id);
      if(upextendedAttrs != null){
        upextendedAttrs = ObjectCopyUtils.copyProperties(extendedAttrs,upextendedAttrs,true);
      }
      return XfR.ok(extendedAttrsServiceImpl.updateById(upextendedAttrs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extendedattrss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extendedAttrsServiceImpl.removeById(id));
  }

  @PostMapping("/extendedattrss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "extended_attrs");
     params.put("request", condition);

     return XfR.ok(extendedAttrsServiceImpl.querys(params));
  }

}
