package com.xforceplus.studymaoyangguang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studymaoyangguang.entity.Operator;
import com.xforceplus.studymaoyangguang.service.IOperatorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-09
 */
@RestController
public class OperatorController {

  @Autowired
  private IOperatorService operatorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param operator ${table.comment}
   * @return
   */
  @GetMapping("/operators" )
  public XfR getOperators(XfPage page, Operator operator) {
    return XfR.ok(operatorServiceImpl.page(page, Wrappers.query(operator)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/operators/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(operatorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param operator ${table.comment}
   * @return XfR
   */
  @PostMapping("/operators")
  public XfR save(@RequestBody Operator operator) {
     return XfR.ok(operatorServiceImpl.save(operator));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param operator ${table.comment}
   * @return XfR
   */
  @PutMapping("/operators/{id}")
  public XfR putUpdate(@RequestBody Operator operator,@PathVariable Long id) {
      operator.setId(id);
      return XfR.ok(operatorServiceImpl.updateById(operator));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param operator ${table.comment}
   * @return XfR
   */
  @PatchMapping("/operators/{id}")
  public XfR patchUpdate(@RequestBody Operator operator,@PathVariable Long id) {
      Operator upoperator = operatorServiceImpl.getById(id);
      if(upoperator != null){
        upoperator = ObjectCopyUtils.copyProperties(operator,upoperator,true);
      }
      return XfR.ok(operatorServiceImpl.updateById(upoperator));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/operators/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(operatorServiceImpl.removeById(id));
  }

  @PostMapping("/operators/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "operator");
     params.put("request", condition);

     return XfR.ok(operatorServiceImpl.querys(params));
  }

}
