package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 运算符
 * </p>
 *
 * @author ultraman
 * @since 2021-05-09
 */
public enum Operator {

    EQ("eq", "相等"),
    NE("ne", "不相等"),
    LIKE("like", "模糊匹配"),
    IN("in", "包含"),
    NI("ni", "不包含"),
    GT("gt", "大于"),
    LT("lt", "小于"),
    GE("ge", "大于等于"),
    LE("le", "小于等于");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Operator(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Operator fromCode(String code){
        switch(code) {
            case "eq":
                return EQ;
            case "ne":
                return NE;
            case "like":
                return LIKE;
            case "in":
                return IN;
            case "ni":
                return NI;
            case "gt":
                return GT;
            case "lt":
                return LT;
            case "ge":
                return GE;
            case "le":
                return LE;
            default:
                return null;
        }
    }
}
