package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 职级
 * </p>
 *
 * @author ultraman
 * @since 2021-05-09
 */
public enum Rank {

    P3("P3", "P3级别"),
    P4("P4", "P4级别"),
    P5("P5", "P5级别"),
    P6("P6", "P6级别"),
    P7("P7", "P7级别"),
    P8("P8", "P8级别"),
    P9("P9", "P9级别"),
    P10("P10", "P10级别"),
    P11("P11", "P11级别"),
    M3("M3", "M3级别"),
    M4("M4", "M4级别"),
    M5("M5", "M5级别");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Rank(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Rank fromCode(String code){
        switch(code) {
            case "P3":
                return P3;
            case "P4":
                return P4;
            case "P5":
                return P5;
            case "P6":
                return P6;
            case "P7":
                return P7;
            case "P8":
                return P8;
            case "P9":
                return P9;
            case "P10":
                return P10;
            case "P11":
                return P11;
            case "M3":
                return M3;
            case "M4":
                return M4;
            case "M5":
                return M5;
            default:
                return null;
        }
    }
}
