package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InfoBI implements Serializable {

  private static final long serialVersionUID=1L;

  private String taxNumber;

  private String productName;

  private String middleGroundCode;

  private BigDecimal amountUsage;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String middleGroundName;

  private String productCode;

  private String tentant;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startingTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endingTime;

  private String unit;

  private String tentantCode;

  private String status;

  private String chargeCode;

  private Long year;

  private Long month;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tax_number", taxNumber);
      map.put("product_name", productName);
      map.put("middle_ground_code", middleGroundCode);
      map.put("amount_usage", amountUsage);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("middle_ground_name", middleGroundName);
      map.put("product_code", productCode);
      map.put("tentant", tentant);
      map.put("starting_time", BocpGenUtils.toTimestamp(startingTime));
      map.put("ending_time", BocpGenUtils.toTimestamp(endingTime));
      map.put("unit", unit);
      map.put("tentant_code", tentantCode);
      map.put("status", status);
      map.put("charge_code", chargeCode);
      map.put("year", year);
      map.put("month", month);
      return map;
  }

  public static InfoBI fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InfoBI entity = new InfoBI();
    if(map.containsKey("tax_number")) {
      Object obj = map.get("tax_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("middle_ground_code")) {
      Object obj = map.get("middle_ground_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMiddleGroundCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_usage")) {
      Object obj = map.get("amount_usage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountUsage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountUsage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountUsage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountUsage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountUsage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("middle_ground_name")) {
      Object obj = map.get("middle_ground_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMiddleGroundName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tentant")) {
      Object obj = map.get("tentant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTentant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("starting_time")) {
      Object obj = map.get("starting_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartingTime(null);
      }
    }
    if(map.containsKey("ending_time")) {
      Object obj = map.get("ending_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndingTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndingTime(null);
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tentant_code")) {
      Object obj = map.get("tentant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTentantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
