package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ProductServiceDev implements Serializable {

  private static final long serialVersionUID=1L;

  private String productSrvKitCode;

  private String projectCode;

  private String costCode;

  private String costBelong;

  private String productName;

  private String productCode;

  private String productPhase;

  private BigDecimal productPrice;

  private String unit;

  private BigDecimal count;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;

  private String submitStatus;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("product_srv_kit_code", productSrvKitCode);
      map.put("project_code", projectCode);
      map.put("cost_code", costCode);
      map.put("cost_belong", costBelong);
      map.put("product_name", productName);
      map.put("product_code", productCode);
      map.put("product_phase", productPhase);
      map.put("product_price", productPrice);
      map.put("unit", unit);
      map.put("count", count);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("submit_status", submitStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ProductServiceDev fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    ProductServiceDev entity = new ProductServiceDev();
    if(map.containsKey("product_srv_kit_code")) {
      Object obj = map.get("product_srv_kit_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductSrvKitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_code")) {
      Object obj = map.get("project_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_phase")) {
      Object obj = map.get("product_phase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductPhase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_price")) {
      Object obj = map.get("product_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setProductPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("count")) {
      Object obj = map.get("count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
