package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountingDocs implements Serializable {

  private static final long serialVersionUID=1L;

  private String rank;

  private String projectCode;

  private String costCode;

  private String costBelong;

  private String productDevCode;

  private String producePhase;

  private String function;

  private String category;

  private String reportPeople;

  private BigDecimal reportDuration;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reportTime;

  private String costAllocationCode;

  private String productSrvKitCode;

  private BigDecimal amount;

  private String productName;

  private String productCode;

  private BigDecimal productPrice;

  private String unit;

  private BigDecimal count;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reimburseTime;

  private String number;

  private String generateStatus;

  private String chargeCode;

  private String chargeAllocationType;

  private String allocationNumber;

  private String costOrgCode;

  private String costOrgName;

  private String benefitOrgCode;

  private String benefitOrgName;

  private String statementsType;

  private String accountingProject;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;

  private String subjectCode;

  private String subjectName;

  private String originalCurrency;

  private String debit;

  private String credit;

  private String subjectDetail;

  private String costDetail;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewTime;

  private String projectName;

  private String staffCode;

  private String staffName;

  private String departmentName;

  private String departmentCode;

  private String billCode;

  private String accountingYear;

  private String accountingMonth;

  private String voucher;

  private String currencyCode;

  private String currencyName;

  private String maker;

  private String reviewer;

  private String approver;

  private String cashier;

  private String manager;

  private String settlementWay;

  private String settlementNum;

  private String countUnit;

  private BigDecimal unitPrice;

  private String referenceInfo;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessDate;

  private String transactionNum;

  private Long attachmentNum;

  private Long serialNum;

  private String systemModule;

  private String businessDesc;

  private BigDecimal exchangeRate;

  private Long entryNum;

  private String post;

  private String mechanism;

  private BigDecimal cashFlow;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private Long voucherNum;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rank", rank);
      map.put("project_code", projectCode);
      map.put("cost_code", costCode);
      map.put("cost_belong", costBelong);
      map.put("product_dev_code", productDevCode);
      map.put("produce_phase", producePhase);
      map.put("function", function);
      map.put("category", category);
      map.put("report_people", reportPeople);
      map.put("report_duration", reportDuration);
      map.put("report_time", BocpGenUtils.toTimestamp(reportTime));
      map.put("cost_allocation_code", costAllocationCode);
      map.put("product_srv_kit_code", productSrvKitCode);
      map.put("amount", amount);
      map.put("product_name", productName);
      map.put("product_code", productCode);
      map.put("product_price", productPrice);
      map.put("unit", unit);
      map.put("count", count);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("reimburse_time", BocpGenUtils.toTimestamp(reimburseTime));
      map.put("number", number);
      map.put("generate_status", generateStatus);
      map.put("charge_code", chargeCode);
      map.put("charge_allocation_type", chargeAllocationType);
      map.put("allocation_number", allocationNumber);
      map.put("cost_org_code", costOrgCode);
      map.put("cost_org_name", costOrgName);
      map.put("benefit_org_code", benefitOrgCode);
      map.put("benefit_org_name", benefitOrgName);
      map.put("statements_type", statementsType);
      map.put("accounting_project", accountingProject);
      map.put("document_date", BocpGenUtils.toTimestamp(documentDate));
      map.put("subject_code", subjectCode);
      map.put("subject_name", subjectName);
      map.put("original_currency", originalCurrency);
      map.put("debit", debit);
      map.put("credit", credit);
      map.put("subject_detail", subjectDetail);
      map.put("cost_detail", costDetail);
      map.put("review_time", BocpGenUtils.toTimestamp(reviewTime));
      map.put("project_name", projectName);
      map.put("staff_code", staffCode);
      map.put("staff_name", staffName);
      map.put("department_name", departmentName);
      map.put("department_code", departmentCode);
      map.put("bill_code", billCode);
      map.put("accounting_year", accountingYear);
      map.put("accounting_month", accountingMonth);
      map.put("voucher", voucher);
      map.put("currency_code", currencyCode);
      map.put("currency_name", currencyName);
      map.put("maker", maker);
      map.put("reviewer", reviewer);
      map.put("approver", approver);
      map.put("cashier", cashier);
      map.put("manager", manager);
      map.put("settlement_way", settlementWay);
      map.put("settlement_num", settlementNum);
      map.put("count_unit", countUnit);
      map.put("unit_price", unitPrice);
      map.put("reference_info", referenceInfo);
      map.put("business_date", BocpGenUtils.toTimestamp(businessDate));
      map.put("transaction_num", transactionNum);
      map.put("attachment_num", attachmentNum);
      map.put("serial_num", serialNum);
      map.put("system_module", systemModule);
      map.put("business_desc", businessDesc);
      map.put("exchange_rate", exchangeRate);
      map.put("entry_num", entryNum);
      map.put("post", post);
      map.put("mechanism", mechanism);
      map.put("cash_flow", cashFlow);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("voucher_num", voucherNum);
      return map;
  }

  public static AccountingDocs fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    AccountingDocs entity = new AccountingDocs();
    if(map.containsKey("rank")) {
      Object obj = map.get("rank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_code")) {
      Object obj = map.get("project_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_dev_code")) {
      Object obj = map.get("product_dev_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductDevCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produce_phase")) {
      Object obj = map.get("produce_phase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProducePhase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function")) {
      Object obj = map.get("function");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_people")) {
      Object obj = map.get("report_people");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReportPeople((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_duration")) {
      Object obj = map.get("report_duration");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReportDuration((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReportDuration(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReportDuration(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReportDuration(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReportDuration(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReportTime(null);
      }
    }
    if(map.containsKey("cost_allocation_code")) {
      Object obj = map.get("cost_allocation_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostAllocationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_srv_kit_code")) {
      Object obj = map.get("product_srv_kit_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductSrvKitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("product_name")) {
      Object obj = map.get("product_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_price")) {
      Object obj = map.get("product_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setProductPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setProductPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setProductPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setProductPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProductPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("count")) {
      Object obj = map.get("count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("reimburse_time")) {
      Object obj = map.get("reimburse_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReimburseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReimburseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReimburseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReimburseTime(null);
      }
    }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("generate_status")) {
      Object obj = map.get("generate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGenerateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_allocation_type")) {
      Object obj = map.get("charge_allocation_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeAllocationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allocation_number")) {
      Object obj = map.get("allocation_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAllocationNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_org_code")) {
      Object obj = map.get("cost_org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_org_name")) {
      Object obj = map.get("cost_org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("benefit_org_code")) {
      Object obj = map.get("benefit_org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("benefit_org_name")) {
      Object obj = map.get("benefit_org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statements_type")) {
      Object obj = map.get("statements_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_project")) {
      Object obj = map.get("accounting_project");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountingProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_date")) {
      Object obj = map.get("document_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("subject_code")) {
      Object obj = map.get("subject_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subject_name")) {
      Object obj = map.get("subject_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_currency")) {
      Object obj = map.get("original_currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debit")) {
      Object obj = map.get("debit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDebit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("credit")) {
      Object obj = map.get("credit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCredit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subject_detail")) {
      Object obj = map.get("subject_detail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubjectDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_detail")) {
      Object obj = map.get("cost_detail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewTime(null);
      }
    }
    if(map.containsKey("project_name")) {
      Object obj = map.get("project_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staff_code")) {
      Object obj = map.get("staff_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staff_name")) {
      Object obj = map.get("staff_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_code")) {
      Object obj = map.get("department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_year")) {
      Object obj = map.get("accounting_year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountingYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accounting_month")) {
      Object obj = map.get("accounting_month");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountingMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher")) {
      Object obj = map.get("voucher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVoucher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_code")) {
      Object obj = map.get("currency_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_name")) {
      Object obj = map.get("currency_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrencyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("maker")) {
      Object obj = map.get("maker");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaker((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approver")) {
      Object obj = map.get("approver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier")) {
      Object obj = map.get("cashier");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashier((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manager")) {
      Object obj = map.get("manager");
      if(obj != null) {
        if(obj instanceof String){
          entity.setManager((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_way")) {
      Object obj = map.get("settlement_way");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_num")) {
      Object obj = map.get("settlement_num");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("count_unit")) {
      Object obj = map.get("count_unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCountUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("reference_info")) {
      Object obj = map.get("reference_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferenceInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_date")) {
      Object obj = map.get("business_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBusinessDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBusinessDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessDate(null);
      }
    }
    if(map.containsKey("transaction_num")) {
      Object obj = map.get("transaction_num");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTransactionNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_num")) {
      Object obj = map.get("attachment_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAttachmentNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setAttachmentNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAttachmentNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("serial_num")) {
      Object obj = map.get("serial_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSerialNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setSerialNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSerialNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("system_module")) {
      Object obj = map.get("system_module");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSystemModule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_desc")) {
      Object obj = map.get("business_desc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchange_rate")) {
      Object obj = map.get("exchange_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setExchangeRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setExchangeRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setExchangeRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setExchangeRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExchangeRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("entry_num")) {
      Object obj = map.get("entry_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntryNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setEntryNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setEntryNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("post")) {
      Object obj = map.get("post");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPost((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mechanism")) {
      Object obj = map.get("mechanism");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMechanism((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cash_flow")) {
      Object obj = map.get("cash_flow");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCashFlow((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCashFlow(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCashFlow(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setCashFlow(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCashFlow(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_num")) {
      Object obj = map.get("voucher_num");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVoucherNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setVoucherNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVoucherNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
