package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Consumption implements Serializable {

  private static final long serialVersionUID=1L;

  private BigDecimal consumption;

  private String benefitOrgsCode;

  private String benefitOrgsName;

  private String ruleCode;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String unit;

  private String belongOrgName;

  private String belongOrgCode;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statisticalStartTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statisticalEndTime;

  private String chargeCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("consumption", consumption);
      map.put("benefit_orgs_code", benefitOrgsCode);
      map.put("benefit_orgs_name", benefitOrgsName);
      map.put("rule_code", ruleCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("unit", unit);
      map.put("belong_org_name", belongOrgName);
      map.put("belong_org_code", belongOrgCode);
      map.put("statistical_start_time", BocpGenUtils.toTimestamp(statisticalStartTime));
      map.put("statistical_end_time", BocpGenUtils.toTimestamp(statisticalEndTime));
      map.put("charge_code", chargeCode);
      return map;
  }

  public static Consumption fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Consumption entity = new Consumption();
    if(map.containsKey("consumption")) {
      Object obj = map.get("consumption");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setConsumption((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setConsumption(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setConsumption(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setConsumption(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setConsumption(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("benefit_orgs_code")) {
      Object obj = map.get("benefit_orgs_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("benefit_orgs_name")) {
      Object obj = map.get("benefit_orgs_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rule_code")) {
      Object obj = map.get("rule_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRuleCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belong_org_name")) {
      Object obj = map.get("belong_org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belong_org_code")) {
      Object obj = map.get("belong_org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statistical_start_time")) {
      Object obj = map.get("statistical_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatisticalStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStatisticalStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStatisticalStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatisticalStartTime(null);
      }
    }
    if(map.containsKey("statistical_end_time")) {
      Object obj = map.get("statistical_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatisticalEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStatisticalEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStatisticalEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatisticalEndTime(null);
      }
    }
    if(map.containsKey("charge_code")) {
      Object obj = map.get("charge_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
