package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品研发编码
 * </p>
 *
 * @author ultraman
 * @since 2021-05-10
 */
public enum ProductDevCode {

    _1("1", "2.0销项"),
    _2("2", "3.0进项"),
    _3("3", "3.0销项"),
    _4("4", "4.0进项"),
    _5("5", "4.0销项"),
    _6("6", "结算协同产品"),
    _7("7", "电子影像"),
    _8("8", "电子档案"),
    _0("0", "2.0进项");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductDevCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductDevCode fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
