package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配字段
 * </p>
 *
 * @author ultraman
 * @since 2021-05-10
 */
public enum MatchField {

    COST_CODE("cost_code", "成本编码"),
    COST_DETAIL("cost_detail", "费用子项"),
    AMOUNT("amount", "金额"),
    BENEFIT_ORG_NAME("benefit_org_name", "受益主体名称"),
    BILL_CODE("bill_code", "单据号"),
    COUNT("count", "数量"),
    COST_BELONG("cost_belong", "成本归属"),
    COST_ORG_CODE("cost_org_code", "发生主体编码"),
    COST_ORG_NAME("cost_org_name", "发生主体名称"),
    DEPARTMENT_CODE("department_code", "部门编码"),
    DEPARTMENT_NAME("department_name", "部门名称"),
    FUNCTION("function", "职能"),
    PRODUCE_PHASE("produce_phase", "产品阶段"),
    PRODUCT_CODE("product_code", "产品编码"),
    PRODUCT_DEV_CODE("product_dev_code", "产品研发编码"),
    PRODUCT_NAME("product_name", "产品名称"),
    PRODUCT_PRICE("product_price", "成本单价"),
    PRODUCT_SRV_KIT_CODE("product_srv_kit_code", "产品服务包编码"),
    PROJECT_CODE("project_code", "项目编码"),
    PROJECT_NAME("project_name", "项目名称"),
    RANK("rank", "职级"),
    REVIEW_TIME("review_time", "审核时间"),
    REPORT_TIME("report_time", "申报时间"),
    SIGN_TIME("sign_time", "签约时间"),
    STAFF_CODE("staff_code", "员工编码"),
    STAFF_NAME("staff_name", "员工名称"),
    STATEMENTS_TYPE("statements_type", "报表类型"),
    UNIT_PRICE("unit_price", "单价");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    MatchField(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchField fromCode(String code){
        switch(code) {
            case "cost_code":
                return COST_CODE;
            case "cost_detail":
                return COST_DETAIL;
            case "amount":
                return AMOUNT;
            case "benefit_org_name":
                return BENEFIT_ORG_NAME;
            case "bill_code":
                return BILL_CODE;
            case "count":
                return COUNT;
            case "cost_belong":
                return COST_BELONG;
            case "cost_org_code":
                return COST_ORG_CODE;
            case "cost_org_name":
                return COST_ORG_NAME;
            case "department_code":
                return DEPARTMENT_CODE;
            case "department_name":
                return DEPARTMENT_NAME;
            case "function":
                return FUNCTION;
            case "produce_phase":
                return PRODUCE_PHASE;
            case "product_code":
                return PRODUCT_CODE;
            case "product_dev_code":
                return PRODUCT_DEV_CODE;
            case "product_name":
                return PRODUCT_NAME;
            case "product_price":
                return PRODUCT_PRICE;
            case "product_srv_kit_code":
                return PRODUCT_SRV_KIT_CODE;
            case "project_code":
                return PROJECT_CODE;
            case "project_name":
                return PROJECT_NAME;
            case "rank":
                return RANK;
            case "review_time":
                return REVIEW_TIME;
            case "report_time":
                return REPORT_TIME;
            case "sign_time":
                return SIGN_TIME;
            case "staff_code":
                return STAFF_CODE;
            case "staff_name":
                return STAFF_NAME;
            case "statements_type":
                return STATEMENTS_TYPE;
            case "unit_price":
                return UNIT_PRICE;
            default:
                return null;
        }
    }
}
