package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 生成字段
 * </p>
 *
 * @author ultraman
 * @since 2021-05-11
 */
public enum GenerateField {

    ACCOUNTING_PROJECT("accounting_project", "核算项目"),
    SUBJECT_DETAIL("subject_detail", "凭证摘要"),
    APPROVER("approver", "核准"),
    ATTACHMENT_NUM("attachment_num", "附件数"),
    BUSINESS_DESC("business_desc", "业务描述"),
    CASH_FLOW("cash_flow", "现金流量"),
    CASHIER("cashier", "出纳"),
    MAKER("maker", "制单"),
    MANAGER("manager", "经办"),
    MECHANISM("mechanism", "机制凭证"),
    REVIEWER("reviewer", "审核"),
    SETTLEMENT_NUM("settlement_num", "结算号"),
    SETTLEMENT_WAY("settlement_way", "结算方式"),
    SYSTEM_MODULE("system_module", "系统模块"),
    TRANSACTION_NUM("transaction_num", "往来业务编号");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    GenerateField(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GenerateField fromCode(String code){
        switch(code) {
            case "accounting_project":
                return ACCOUNTING_PROJECT;
            case "subject_detail":
                return SUBJECT_DETAIL;
            case "approver":
                return APPROVER;
            case "attachment_num":
                return ATTACHMENT_NUM;
            case "business_desc":
                return BUSINESS_DESC;
            case "cash_flow":
                return CASH_FLOW;
            case "cashier":
                return CASHIER;
            case "maker":
                return MAKER;
            case "manager":
                return MANAGER;
            case "mechanism":
                return MECHANISM;
            case "reviewer":
                return REVIEWER;
            case "settlement_num":
                return SETTLEMENT_NUM;
            case "settlement_way":
                return SETTLEMENT_WAY;
            case "system_module":
                return SYSTEM_MODULE;
            case "transaction_num":
                return TRANSACTION_NUM;
            default:
                return null;
        }
    }
}
