package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成本类型
 * </p>
 *
 * @author ultraman
 * @since 2021-05-11
 */
public enum CostType {

    _1("1", "A类"),
    _2("2", "B类"),
    _3("3", "C类"),
    _0("0", "D类");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CostType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CostType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
