package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CostAllocation implements Serializable {

  private static final long serialVersionUID=1L;

  private String costAllocationCode;

  private String costCode;

  private BigDecimal amount;

  private String projectCode;

  private String productCode;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reimburseTime;

  private String number;

  private String costBelong;

  private String productDevCode;

  private String submitStatus;

  private String costType;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String costOrgCode;

  private String costOrgName;

  private String benefitOrgCode;

  private String benefitOrgName;

  private String statementsType;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewTime;

  private String costDetail;

  private String projectName;

  private String departmentName;

  private String departmentCode;

  private String staffCode;

  private String staffName;

  private String billCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("cost_allocation_code", costAllocationCode);
      map.put("cost_code", costCode);
      map.put("amount", amount);
      map.put("project_code", projectCode);
      map.put("product_code", productCode);
      map.put("reimburse_time", BocpGenUtils.toTimestamp(reimburseTime));
      map.put("number", number);
      map.put("cost_belong", costBelong);
      map.put("product_dev_code", productDevCode);
      map.put("submit_status", submitStatus);
      map.put("cost_type", costType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("cost_org_code", costOrgCode);
      map.put("cost_org_name", costOrgName);
      map.put("benefit_org_code", benefitOrgCode);
      map.put("benefit_org_name", benefitOrgName);
      map.put("statements_type", statementsType);
      map.put("review_time", BocpGenUtils.toTimestamp(reviewTime));
      map.put("cost_detail", costDetail);
      map.put("project_name", projectName);
      map.put("department_name", departmentName);
      map.put("department_code", departmentCode);
      map.put("staff_code", staffCode);
      map.put("staff_name", staffName);
      map.put("bill_code", billCode);
      return map;
  }

  public static CostAllocation fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    CostAllocation entity = new CostAllocation();
    if(map.containsKey("cost_allocation_code")) {
      Object obj = map.get("cost_allocation_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostAllocationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("project_code")) {
      Object obj = map.get("project_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_code")) {
      Object obj = map.get("product_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reimburse_time")) {
      Object obj = map.get("reimburse_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReimburseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReimburseTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReimburseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReimburseTime(null);
      }
    }
    if(map.containsKey("number")) {
      Object obj = map.get("number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_dev_code")) {
      Object obj = map.get("product_dev_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductDevCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_status")) {
      Object obj = map.get("submit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSubmitStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_type")) {
      Object obj = map.get("cost_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_org_code")) {
      Object obj = map.get("cost_org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_org_name")) {
      Object obj = map.get("cost_org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("benefit_org_code")) {
      Object obj = map.get("benefit_org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("benefit_org_name")) {
      Object obj = map.get("benefit_org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBenefitOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statements_type")) {
      Object obj = map.get("statements_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewTime(null);
      }
    }
    if(map.containsKey("cost_detail")) {
      Object obj = map.get("cost_detail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_name")) {
      Object obj = map.get("project_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_code")) {
      Object obj = map.get("department_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staff_code")) {
      Object obj = map.get("staff_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("staff_name")) {
      Object obj = map.get("staff_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStaffName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
