package com.xforceplus.studyweikai.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 成本主信息提交状态
 * </p>
 *
 * @author ultraman
 * @since 2021-07-20
 */
public enum SubmitStatus {

    _1("1", "已提交"),
    _0("0", "无需分摊"),
    _2("2", "已分摊"),
    _3("3", "未分摊");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubmitStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubmitStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
