package com.xforceplus.studyweikai.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class WorkingHours implements Serializable {

  private static final long serialVersionUID=1L;

  private String rank;

  private String projectCode;

  private String costCode;

  private String costBelong;

  private String productDevCode;

  private String producePhase;

  private String function;

  private String category;

  private String reportPeople;

  private BigDecimal reportDuration;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reportTime;

  private String workingHoursCode;

  private String calculateStatus;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rank", rank);
      map.put("project_code", projectCode);
      map.put("cost_code", costCode);
      map.put("cost_belong", costBelong);
      map.put("product_dev_code", productDevCode);
      map.put("produce_phase", producePhase);
      map.put("function", function);
      map.put("category", category);
      map.put("report_people", reportPeople);
      map.put("report_duration", reportDuration);
      map.put("report_time", BocpGenUtils.toTimestamp(reportTime));
      map.put("working_hours_code", workingHoursCode);
      map.put("calculate_status", calculateStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static WorkingHours fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    WorkingHours entity = new WorkingHours();
    if(map.containsKey("rank")) {
      Object obj = map.get("rank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project_code")) {
      Object obj = map.get("project_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_code")) {
      Object obj = map.get("cost_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cost_belong")) {
      Object obj = map.get("cost_belong");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCostBelong((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product_dev_code")) {
      Object obj = map.get("product_dev_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductDevCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produce_phase")) {
      Object obj = map.get("produce_phase");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProducePhase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("function")) {
      Object obj = map.get("function");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_people")) {
      Object obj = map.get("report_people");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReportPeople((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_duration")) {
      Object obj = map.get("report_duration");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReportDuration((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReportDuration(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReportDuration(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReportDuration(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReportDuration(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("report_time")) {
      Object obj = map.get("report_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReportTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReportTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReportTime(null);
      }
    }
    if(map.containsKey("working_hours_code")) {
      Object obj = map.get("working_hours_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWorkingHoursCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
