package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.ProductServiceDev;
import com.xforceplus.studyweikai.service.IProductServiceDevService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class ProductServiceDevController {

  @Autowired
  private IProductServiceDevService productServiceDevServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productServiceDev ${table.comment}
   * @return
   */
  @GetMapping("/productservicedevs" )
  public XfR getProductServiceDevs(XfPage page, ProductServiceDev productServiceDev) {
    return XfR.ok(productServiceDevServiceImpl.page(page, Wrappers.query(productServiceDev)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productservicedevs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productServiceDevServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productServiceDev ${table.comment}
   * @return XfR
   */
  @PostMapping("/productservicedevs")
  public XfR save(@RequestBody ProductServiceDev productServiceDev) {
     return XfR.ok(productServiceDevServiceImpl.save(productServiceDev));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productServiceDev ${table.comment}
   * @return XfR
   */
  @PutMapping("/productservicedevs/{id}")
  public XfR putUpdate(@RequestBody ProductServiceDev productServiceDev,@PathVariable Long id) {
      productServiceDev.setId(id);
      return XfR.ok(productServiceDevServiceImpl.updateById(productServiceDev));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productServiceDev ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productservicedevs/{id}")
  public XfR patchUpdate(@RequestBody ProductServiceDev productServiceDev,@PathVariable Long id) {
      ProductServiceDev upproductServiceDev = productServiceDevServiceImpl.getById(id);
      if(upproductServiceDev != null){
        upproductServiceDev = ObjectCopyUtils.copyProperties(productServiceDev,upproductServiceDev,true);
      }
      return XfR.ok(productServiceDevServiceImpl.updateById(upproductServiceDev));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productservicedevs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productServiceDevServiceImpl.removeById(id));
  }

  @PostMapping("/productservicedevs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_service_dev");
     params.put("request", condition);

     return XfR.ok(productServiceDevServiceImpl.querys(params));
  }

}
