package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.WorkingHours;
import com.xforceplus.studyweikai.service.IWorkingHoursService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-05
 */
@RestController
public class WorkingHoursController {

  @Autowired
  private IWorkingHoursService workingHoursServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workingHours ${table.comment}
   * @return
   */
  @GetMapping("/workinghourss" )
  public XfR getWorkingHourss(XfPage page, WorkingHours workingHours) {
    return XfR.ok(workingHoursServiceImpl.page(page, Wrappers.query(workingHours)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/workinghourss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workingHoursServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workingHours ${table.comment}
   * @return XfR
   */
  @PostMapping("/workinghourss")
  public XfR save(@RequestBody WorkingHours workingHours) {
     return XfR.ok(workingHoursServiceImpl.save(workingHours));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workingHours ${table.comment}
   * @return XfR
   */
  @PutMapping("/workinghourss/{id}")
  public XfR putUpdate(@RequestBody WorkingHours workingHours,@PathVariable Long id) {
      workingHours.setId(id);
      return XfR.ok(workingHoursServiceImpl.updateById(workingHours));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workingHours ${table.comment}
   * @return XfR
   */
  @PatchMapping("/workinghourss/{id}")
  public XfR patchUpdate(@RequestBody WorkingHours workingHours,@PathVariable Long id) {
      WorkingHours upworkingHours = workingHoursServiceImpl.getById(id);
      if(upworkingHours != null){
        upworkingHours = ObjectCopyUtils.copyProperties(workingHours,upworkingHours,true);
      }
      return XfR.ok(workingHoursServiceImpl.updateById(upworkingHours));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/workinghourss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workingHoursServiceImpl.removeById(id));
  }

  @PostMapping("/workinghourss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "working_hours");
     params.put("request", condition);

     return XfR.ok(workingHoursServiceImpl.querys(params));
  }

}
