package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.ChargeCode;
import com.xforceplus.studyweikai.service.IChargeCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-10
 */
@RestController
public class ChargeCodeController {

  @Autowired
  private IChargeCodeService chargeCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCode ${table.comment}
   * @return
   */
  @GetMapping("/chargecodes" )
  public XfR getChargeCodes(XfPage page, ChargeCode chargeCode) {
    return XfR.ok(chargeCodeServiceImpl.page(page, Wrappers.query(chargeCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodes")
  public XfR save(@RequestBody ChargeCode chargeCode) {
     return XfR.ok(chargeCodeServiceImpl.save(chargeCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodes/{id}")
  public XfR putUpdate(@RequestBody ChargeCode chargeCode,@PathVariable Long id) {
      chargeCode.setId(id);
      return XfR.ok(chargeCodeServiceImpl.updateById(chargeCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodes/{id}")
  public XfR patchUpdate(@RequestBody ChargeCode chargeCode,@PathVariable Long id) {
      ChargeCode upchargeCode = chargeCodeServiceImpl.getById(id);
      if(upchargeCode != null){
        upchargeCode = ObjectCopyUtils.copyProperties(chargeCode,upchargeCode,true);
      }
      return XfR.ok(chargeCodeServiceImpl.updateById(upchargeCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code");
     params.put("request", condition);

     return XfR.ok(chargeCodeServiceImpl.querys(params));
  }

}
