package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.AcccountingRules;
import com.xforceplus.studyweikai.service.IAcccountingRulesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-10
 */
@RestController
public class AcccountingRulesController {

  @Autowired
  private IAcccountingRulesService acccountingRulesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param acccountingRules ${table.comment}
   * @return
   */
  @GetMapping("/acccountingruless" )
  public XfR getAcccountingRuless(XfPage page, AcccountingRules acccountingRules) {
    return XfR.ok(acccountingRulesServiceImpl.page(page, Wrappers.query(acccountingRules)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/acccountingruless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(acccountingRulesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param acccountingRules ${table.comment}
   * @return XfR
   */
  @PostMapping("/acccountingruless")
  public XfR save(@RequestBody AcccountingRules acccountingRules) {
     return XfR.ok(acccountingRulesServiceImpl.save(acccountingRules));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param acccountingRules ${table.comment}
   * @return XfR
   */
  @PutMapping("/acccountingruless/{id}")
  public XfR putUpdate(@RequestBody AcccountingRules acccountingRules,@PathVariable Long id) {
      acccountingRules.setId(id);
      return XfR.ok(acccountingRulesServiceImpl.updateById(acccountingRules));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param acccountingRules ${table.comment}
   * @return XfR
   */
  @PatchMapping("/acccountingruless/{id}")
  public XfR patchUpdate(@RequestBody AcccountingRules acccountingRules,@PathVariable Long id) {
      AcccountingRules upacccountingRules = acccountingRulesServiceImpl.getById(id);
      if(upacccountingRules != null){
        upacccountingRules = ObjectCopyUtils.copyProperties(acccountingRules,upacccountingRules,true);
      }
      return XfR.ok(acccountingRulesServiceImpl.updateById(upacccountingRules));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/acccountingruless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(acccountingRulesServiceImpl.removeById(id));
  }

  @PostMapping("/acccountingruless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "acccounting_rules");
     params.put("request", condition);

     return XfR.ok(acccountingRulesServiceImpl.querys(params));
  }

}
