package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.Charge;
import com.xforceplus.studyweikai.service.IChargeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-10
 */
@RestController
public class ChargeController {

  @Autowired
  private IChargeService chargeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param charge ${table.comment}
   * @return
   */
  @GetMapping("/charges" )
  public XfR getCharges(XfPage page, Charge charge) {
    return XfR.ok(chargeServiceImpl.page(page, Wrappers.query(charge)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/charges/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param charge ${table.comment}
   * @return XfR
   */
  @PostMapping("/charges")
  public XfR save(@RequestBody Charge charge) {
     return XfR.ok(chargeServiceImpl.save(charge));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param charge ${table.comment}
   * @return XfR
   */
  @PutMapping("/charges/{id}")
  public XfR putUpdate(@RequestBody Charge charge,@PathVariable Long id) {
      charge.setId(id);
      return XfR.ok(chargeServiceImpl.updateById(charge));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param charge ${table.comment}
   * @return XfR
   */
  @PatchMapping("/charges/{id}")
  public XfR patchUpdate(@RequestBody Charge charge,@PathVariable Long id) {
      Charge upcharge = chargeServiceImpl.getById(id);
      if(upcharge != null){
        upcharge = ObjectCopyUtils.copyProperties(charge,upcharge,true);
      }
      return XfR.ok(chargeServiceImpl.updateById(upcharge));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/charges/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeServiceImpl.removeById(id));
  }

  @PostMapping("/charges/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge");
     params.put("request", condition);

     return XfR.ok(chargeServiceImpl.querys(params));
  }

}
