package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.AccountingDocs;
import com.xforceplus.studyweikai.service.IAccountingDocsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-11
 */
@RestController
public class AccountingDocsController {

  @Autowired
  private IAccountingDocsService accountingDocsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountingDocs ${table.comment}
   * @return
   */
  @GetMapping("/accountingdocss" )
  public XfR getAccountingDocss(XfPage page, AccountingDocs accountingDocs) {
    return XfR.ok(accountingDocsServiceImpl.page(page, Wrappers.query(accountingDocs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountingdocss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountingDocsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountingDocs ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountingdocss")
  public XfR save(@RequestBody AccountingDocs accountingDocs) {
     return XfR.ok(accountingDocsServiceImpl.save(accountingDocs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountingDocs ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountingdocss/{id}")
  public XfR putUpdate(@RequestBody AccountingDocs accountingDocs,@PathVariable Long id) {
      accountingDocs.setId(id);
      return XfR.ok(accountingDocsServiceImpl.updateById(accountingDocs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountingDocs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountingdocss/{id}")
  public XfR patchUpdate(@RequestBody AccountingDocs accountingDocs,@PathVariable Long id) {
      AccountingDocs upaccountingDocs = accountingDocsServiceImpl.getById(id);
      if(upaccountingDocs != null){
        upaccountingDocs = ObjectCopyUtils.copyProperties(accountingDocs,upaccountingDocs,true);
      }
      return XfR.ok(accountingDocsServiceImpl.updateById(upaccountingDocs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountingdocss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountingDocsServiceImpl.removeById(id));
  }

  @PostMapping("/accountingdocss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "accounting_docs");
     params.put("request", condition);

     return XfR.ok(accountingDocsServiceImpl.querys(params));
  }

}
