package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.FinancialStatements;
import com.xforceplus.studyweikai.service.IFinancialStatementsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-11
 */
@RestController
public class FinancialStatementsController {

  @Autowired
  private IFinancialStatementsService financialStatementsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialStatements ${table.comment}
   * @return
   */
  @GetMapping("/financialstatementss" )
  public XfR getFinancialStatementss(XfPage page, FinancialStatements financialStatements) {
    return XfR.ok(financialStatementsServiceImpl.page(page, Wrappers.query(financialStatements)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialstatementss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialStatementsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialStatements ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialstatementss")
  public XfR save(@RequestBody FinancialStatements financialStatements) {
     return XfR.ok(financialStatementsServiceImpl.save(financialStatements));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialStatements ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialstatementss/{id}")
  public XfR putUpdate(@RequestBody FinancialStatements financialStatements,@PathVariable Long id) {
      financialStatements.setId(id);
      return XfR.ok(financialStatementsServiceImpl.updateById(financialStatements));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialStatements ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialstatementss/{id}")
  public XfR patchUpdate(@RequestBody FinancialStatements financialStatements,@PathVariable Long id) {
      FinancialStatements upfinancialStatements = financialStatementsServiceImpl.getById(id);
      if(upfinancialStatements != null){
        upfinancialStatements = ObjectCopyUtils.copyProperties(financialStatements,upfinancialStatements,true);
      }
      return XfR.ok(financialStatementsServiceImpl.updateById(upfinancialStatements));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialstatementss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialStatementsServiceImpl.removeById(id));
  }

  @PostMapping("/financialstatementss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_statements");
     params.put("request", condition);

     return XfR.ok(financialStatementsServiceImpl.querys(params));
  }

}
