package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.AccountingRuleDetails;
import com.xforceplus.studyweikai.service.IAccountingRuleDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-03-19
 */
@RestController
public class AccountingRuleDetailsController {

  @Autowired
  private IAccountingRuleDetailsService accountingRuleDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountingRuleDetails ${table.comment}
   * @return
   */
  @GetMapping("/accountingruledetailss" )
  public XfR getAccountingRuleDetailss(XfPage page, AccountingRuleDetails accountingRuleDetails) {
    return XfR.ok(accountingRuleDetailsServiceImpl.page(page, Wrappers.query(accountingRuleDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountingruledetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountingRuleDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountingRuleDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountingruledetailss")
  public XfR save(@RequestBody AccountingRuleDetails accountingRuleDetails) {
     return XfR.ok(accountingRuleDetailsServiceImpl.save(accountingRuleDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountingRuleDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountingruledetailss/{id}")
  public XfR putUpdate(@RequestBody AccountingRuleDetails accountingRuleDetails,@PathVariable Long id) {
      accountingRuleDetails.setId(id);
      return XfR.ok(accountingRuleDetailsServiceImpl.updateById(accountingRuleDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountingRuleDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountingruledetailss/{id}")
  public XfR patchUpdate(@RequestBody AccountingRuleDetails accountingRuleDetails,@PathVariable Long id) {
      AccountingRuleDetails upaccountingRuleDetails = accountingRuleDetailsServiceImpl.getById(id);
      if(upaccountingRuleDetails != null){
        upaccountingRuleDetails = ObjectCopyUtils.copyProperties(accountingRuleDetails,upaccountingRuleDetails,true);
      }
      return XfR.ok(accountingRuleDetailsServiceImpl.updateById(upaccountingRuleDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountingruledetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountingRuleDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/accountingruledetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "accounting_rule_details");
     params.put("request", condition);

     return XfR.ok(accountingRuleDetailsServiceImpl.querys(params));
  }

}
