package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.RulesConf;
import com.xforceplus.studyweikai.service.IRulesConfService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class RulesConfController {

  @Autowired
  private IRulesConfService rulesConfServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rulesConf ${table.comment}
   * @return
   */
  @GetMapping("/rulesconfs" )
  public XfR getRulesConfs(XfPage page, RulesConf rulesConf) {
    return XfR.ok(rulesConfServiceImpl.page(page, Wrappers.query(rulesConf)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rulesconfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(rulesConfServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rulesConf ${table.comment}
   * @return XfR
   */
  @PostMapping("/rulesconfs")
  public XfR save(@RequestBody RulesConf rulesConf) {
     return XfR.ok(rulesConfServiceImpl.save(rulesConf));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rulesConf ${table.comment}
   * @return XfR
   */
  @PutMapping("/rulesconfs/{id}")
  public XfR putUpdate(@RequestBody RulesConf rulesConf,@PathVariable Long id) {
      rulesConf.setId(id);
      return XfR.ok(rulesConfServiceImpl.updateById(rulesConf));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rulesConf ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rulesconfs/{id}")
  public XfR patchUpdate(@RequestBody RulesConf rulesConf,@PathVariable Long id) {
      RulesConf uprulesConf = rulesConfServiceImpl.getById(id);
      if(uprulesConf != null){
        uprulesConf = ObjectCopyUtils.copyProperties(rulesConf,uprulesConf,true);
      }
      return XfR.ok(rulesConfServiceImpl.updateById(uprulesConf));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rulesconfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(rulesConfServiceImpl.removeById(id));
  }

  @PostMapping("/rulesconfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rules_conf");
     params.put("request", condition);

     return XfR.ok(rulesConfServiceImpl.querys(params));
  }

}
