package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.Cost;
import com.xforceplus.studyweikai.service.ICostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class CostController {

  @Autowired
  private ICostService costServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cost ${table.comment}
   * @return
   */
  @GetMapping("/costs" )
  public XfR getCosts(XfPage page, Cost cost) {
    return XfR.ok(costServiceImpl.page(page, Wrappers.query(cost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/costs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cost ${table.comment}
   * @return XfR
   */
  @PostMapping("/costs")
  public XfR save(@RequestBody Cost cost) {
     return XfR.ok(costServiceImpl.save(cost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cost ${table.comment}
   * @return XfR
   */
  @PutMapping("/costs/{id}")
  public XfR putUpdate(@RequestBody Cost cost,@PathVariable Long id) {
      cost.setId(id);
      return XfR.ok(costServiceImpl.updateById(cost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/costs/{id}")
  public XfR patchUpdate(@RequestBody Cost cost,@PathVariable Long id) {
      Cost upcost = costServiceImpl.getById(id);
      if(upcost != null){
        upcost = ObjectCopyUtils.copyProperties(cost,upcost,true);
      }
      return XfR.ok(costServiceImpl.updateById(upcost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costServiceImpl.removeById(id));
  }

  @PostMapping("/costs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cost");
     params.put("request", condition);

     return XfR.ok(costServiceImpl.querys(params));
  }

}
