package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.No1;
import com.xforceplus.studyweikai.service.INo1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class No1Controller {

  @Autowired
  private INo1Service no1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param no1 ${table.comment}
   * @return
   */
  @GetMapping("/no1s" )
  public XfR getNo1s(XfPage page, No1 no1) {
    return XfR.ok(no1ServiceImpl.page(page, Wrappers.query(no1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/no1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(no1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param no1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/no1s")
  public XfR save(@RequestBody No1 no1) {
     return XfR.ok(no1ServiceImpl.save(no1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param no1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/no1s/{id}")
  public XfR putUpdate(@RequestBody No1 no1,@PathVariable Long id) {
      no1.setId(id);
      return XfR.ok(no1ServiceImpl.updateById(no1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param no1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/no1s/{id}")
  public XfR patchUpdate(@RequestBody No1 no1,@PathVariable Long id) {
      No1 upno1 = no1ServiceImpl.getById(id);
      if(upno1 != null){
        upno1 = ObjectCopyUtils.copyProperties(no1,upno1,true);
      }
      return XfR.ok(no1ServiceImpl.updateById(upno1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/no1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(no1ServiceImpl.removeById(id));
  }

  @PostMapping("/no1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no1");
     params.put("request", condition);

     return XfR.ok(no1ServiceImpl.querys(params));
  }

}
