package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.No2;
import com.xforceplus.studyweikai.service.INo2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class No2Controller {

  @Autowired
  private INo2Service no2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param no2 ${table.comment}
   * @return
   */
  @GetMapping("/no2s" )
  public XfR getNo2s(XfPage page, No2 no2) {
    return XfR.ok(no2ServiceImpl.page(page, Wrappers.query(no2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/no2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(no2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param no2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/no2s")
  public XfR save(@RequestBody No2 no2) {
     return XfR.ok(no2ServiceImpl.save(no2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param no2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/no2s/{id}")
  public XfR putUpdate(@RequestBody No2 no2,@PathVariable Long id) {
      no2.setId(id);
      return XfR.ok(no2ServiceImpl.updateById(no2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param no2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/no2s/{id}")
  public XfR patchUpdate(@RequestBody No2 no2,@PathVariable Long id) {
      No2 upno2 = no2ServiceImpl.getById(id);
      if(upno2 != null){
        upno2 = ObjectCopyUtils.copyProperties(no2,upno2,true);
      }
      return XfR.ok(no2ServiceImpl.updateById(upno2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/no2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(no2ServiceImpl.removeById(id));
  }

  @PostMapping("/no2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no2");
     params.put("request", condition);

     return XfR.ok(no2ServiceImpl.querys(params));
  }

}
