package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.No3;
import com.xforceplus.studyweikai.service.INo3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class No3Controller {

  @Autowired
  private INo3Service no3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param no3 ${table.comment}
   * @return
   */
  @GetMapping("/no3s" )
  public XfR getNo3s(XfPage page, No3 no3) {
    return XfR.ok(no3ServiceImpl.page(page, Wrappers.query(no3)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/no3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(no3ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param no3 ${table.comment}
   * @return XfR
   */
  @PostMapping("/no3s")
  public XfR save(@RequestBody No3 no3) {
     return XfR.ok(no3ServiceImpl.save(no3));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param no3 ${table.comment}
   * @return XfR
   */
  @PutMapping("/no3s/{id}")
  public XfR putUpdate(@RequestBody No3 no3,@PathVariable Long id) {
      no3.setId(id);
      return XfR.ok(no3ServiceImpl.updateById(no3));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param no3 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/no3s/{id}")
  public XfR patchUpdate(@RequestBody No3 no3,@PathVariable Long id) {
      No3 upno3 = no3ServiceImpl.getById(id);
      if(upno3 != null){
        upno3 = ObjectCopyUtils.copyProperties(no3,upno3,true);
      }
      return XfR.ok(no3ServiceImpl.updateById(upno3));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/no3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(no3ServiceImpl.removeById(id));
  }

  @PostMapping("/no3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no3");
     params.put("request", condition);

     return XfR.ok(no3ServiceImpl.querys(params));
  }

}
