package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.No4;
import com.xforceplus.studyweikai.service.INo4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class No4Controller {

  @Autowired
  private INo4Service no4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param no4 ${table.comment}
   * @return
   */
  @GetMapping("/no4s" )
  public XfR getNo4s(XfPage page, No4 no4) {
    return XfR.ok(no4ServiceImpl.page(page, Wrappers.query(no4)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/no4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(no4ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param no4 ${table.comment}
   * @return XfR
   */
  @PostMapping("/no4s")
  public XfR save(@RequestBody No4 no4) {
     return XfR.ok(no4ServiceImpl.save(no4));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param no4 ${table.comment}
   * @return XfR
   */
  @PutMapping("/no4s/{id}")
  public XfR putUpdate(@RequestBody No4 no4,@PathVariable Long id) {
      no4.setId(id);
      return XfR.ok(no4ServiceImpl.updateById(no4));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param no4 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/no4s/{id}")
  public XfR patchUpdate(@RequestBody No4 no4,@PathVariable Long id) {
      No4 upno4 = no4ServiceImpl.getById(id);
      if(upno4 != null){
        upno4 = ObjectCopyUtils.copyProperties(no4,upno4,true);
      }
      return XfR.ok(no4ServiceImpl.updateById(upno4));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/no4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(no4ServiceImpl.removeById(id));
  }

  @PostMapping("/no4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "no4");
     params.put("request", condition);

     return XfR.ok(no4ServiceImpl.querys(params));
  }

}
