package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.Rule;
import com.xforceplus.studyweikai.service.IRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class RuleController {

  @Autowired
  private IRuleService ruleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param rule ${table.comment}
   * @return
   */
  @GetMapping("/rules" )
  public XfR getRules(XfPage page, Rule rule) {
    return XfR.ok(ruleServiceImpl.page(page, Wrappers.query(rule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/rules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ruleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param rule ${table.comment}
   * @return XfR
   */
  @PostMapping("/rules")
  public XfR save(@RequestBody Rule rule) {
     return XfR.ok(ruleServiceImpl.save(rule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param rule ${table.comment}
   * @return XfR
   */
  @PutMapping("/rules/{id}")
  public XfR putUpdate(@RequestBody Rule rule,@PathVariable Long id) {
      rule.setId(id);
      return XfR.ok(ruleServiceImpl.updateById(rule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param rule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/rules/{id}")
  public XfR patchUpdate(@RequestBody Rule rule,@PathVariable Long id) {
      Rule uprule = ruleServiceImpl.getById(id);
      if(uprule != null){
        uprule = ObjectCopyUtils.copyProperties(rule,uprule,true);
      }
      return XfR.ok(ruleServiceImpl.updateById(uprule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/rules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ruleServiceImpl.removeById(id));
  }

  @PostMapping("/rules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "rule");
     params.put("request", condition);

     return XfR.ok(ruleServiceImpl.querys(params));
  }

}
