package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.Test0705;
import com.xforceplus.studyweikai.service.ITest0705Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class Test0705Controller {

  @Autowired
  private ITest0705Service test0705ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0705 ${table.comment}
   * @return
   */
  @GetMapping("/test0705s" )
  public XfR getTest0705s(XfPage page, Test0705 test0705) {
    return XfR.ok(test0705ServiceImpl.page(page, Wrappers.query(test0705)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0705s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0705ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0705 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0705s")
  public XfR save(@RequestBody Test0705 test0705) {
     return XfR.ok(test0705ServiceImpl.save(test0705));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0705 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0705s/{id}")
  public XfR putUpdate(@RequestBody Test0705 test0705,@PathVariable Long id) {
      test0705.setId(id);
      return XfR.ok(test0705ServiceImpl.updateById(test0705));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0705 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0705s/{id}")
  public XfR patchUpdate(@RequestBody Test0705 test0705,@PathVariable Long id) {
      Test0705 uptest0705 = test0705ServiceImpl.getById(id);
      if(uptest0705 != null){
        uptest0705 = ObjectCopyUtils.copyProperties(test0705,uptest0705,true);
      }
      return XfR.ok(test0705ServiceImpl.updateById(uptest0705));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0705s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0705ServiceImpl.removeById(id));
  }

  @PostMapping("/test0705s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0705");
     params.put("request", condition);

     return XfR.ok(test0705ServiceImpl.querys(params));
  }

}
