package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.WorkingHoursPrice;
import com.xforceplus.studyweikai.service.IWorkingHoursPriceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class WorkingHoursPriceController {

  @Autowired
  private IWorkingHoursPriceService workingHoursPriceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param workingHoursPrice ${table.comment}
   * @return
   */
  @GetMapping("/workinghoursprices" )
  public XfR getWorkingHoursPrices(XfPage page, WorkingHoursPrice workingHoursPrice) {
    return XfR.ok(workingHoursPriceServiceImpl.page(page, Wrappers.query(workingHoursPrice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/workinghoursprices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(workingHoursPriceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param workingHoursPrice ${table.comment}
   * @return XfR
   */
  @PostMapping("/workinghoursprices")
  public XfR save(@RequestBody WorkingHoursPrice workingHoursPrice) {
     return XfR.ok(workingHoursPriceServiceImpl.save(workingHoursPrice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param workingHoursPrice ${table.comment}
   * @return XfR
   */
  @PutMapping("/workinghoursprices/{id}")
  public XfR putUpdate(@RequestBody WorkingHoursPrice workingHoursPrice,@PathVariable Long id) {
      workingHoursPrice.setId(id);
      return XfR.ok(workingHoursPriceServiceImpl.updateById(workingHoursPrice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param workingHoursPrice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/workinghoursprices/{id}")
  public XfR patchUpdate(@RequestBody WorkingHoursPrice workingHoursPrice,@PathVariable Long id) {
      WorkingHoursPrice upworkingHoursPrice = workingHoursPriceServiceImpl.getById(id);
      if(upworkingHoursPrice != null){
        upworkingHoursPrice = ObjectCopyUtils.copyProperties(workingHoursPrice,upworkingHoursPrice,true);
      }
      return XfR.ok(workingHoursPriceServiceImpl.updateById(upworkingHoursPrice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/workinghoursprices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(workingHoursPriceServiceImpl.removeById(id));
  }

  @PostMapping("/workinghoursprices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "working_hours_price");
     params.put("request", condition);

     return XfR.ok(workingHoursPriceServiceImpl.querys(params));
  }

}
