package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.BenefitOrg;
import com.xforceplus.studyweikai.service.IBenefitOrgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-01
 */
@RestController
public class BenefitOrgController {

  @Autowired
  private IBenefitOrgService benefitOrgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param benefitOrg ${table.comment}
   * @return
   */
  @GetMapping("/benefitorgs" )
  public XfR getBenefitOrgs(XfPage page, BenefitOrg benefitOrg) {
    return XfR.ok(benefitOrgServiceImpl.page(page, Wrappers.query(benefitOrg)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/benefitorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(benefitOrgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param benefitOrg ${table.comment}
   * @return XfR
   */
  @PostMapping("/benefitorgs")
  public XfR save(@RequestBody BenefitOrg benefitOrg) {
     return XfR.ok(benefitOrgServiceImpl.save(benefitOrg));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param benefitOrg ${table.comment}
   * @return XfR
   */
  @PutMapping("/benefitorgs/{id}")
  public XfR putUpdate(@RequestBody BenefitOrg benefitOrg,@PathVariable Long id) {
      benefitOrg.setId(id);
      return XfR.ok(benefitOrgServiceImpl.updateById(benefitOrg));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param benefitOrg ${table.comment}
   * @return XfR
   */
  @PatchMapping("/benefitorgs/{id}")
  public XfR patchUpdate(@RequestBody BenefitOrg benefitOrg,@PathVariable Long id) {
      BenefitOrg upbenefitOrg = benefitOrgServiceImpl.getById(id);
      if(upbenefitOrg != null){
        upbenefitOrg = ObjectCopyUtils.copyProperties(benefitOrg,upbenefitOrg,true);
      }
      return XfR.ok(benefitOrgServiceImpl.updateById(upbenefitOrg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/benefitorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(benefitOrgServiceImpl.removeById(id));
  }

  @PostMapping("/benefitorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "benefit_org");
     params.put("request", condition);

     return XfR.ok(benefitOrgServiceImpl.querys(params));
  }

}
