package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.Consumption;
import com.xforceplus.studyweikai.service.IConsumptionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-01
 */
@RestController
public class ConsumptionController {

  @Autowired
  private IConsumptionService consumptionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param consumption ${table.comment}
   * @return
   */
  @GetMapping("/consumptions" )
  public XfR getConsumptions(XfPage page, Consumption consumption) {
    return XfR.ok(consumptionServiceImpl.page(page, Wrappers.query(consumption)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/consumptions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(consumptionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param consumption ${table.comment}
   * @return XfR
   */
  @PostMapping("/consumptions")
  public XfR save(@RequestBody Consumption consumption) {
     return XfR.ok(consumptionServiceImpl.save(consumption));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param consumption ${table.comment}
   * @return XfR
   */
  @PutMapping("/consumptions/{id}")
  public XfR putUpdate(@RequestBody Consumption consumption,@PathVariable Long id) {
      consumption.setId(id);
      return XfR.ok(consumptionServiceImpl.updateById(consumption));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param consumption ${table.comment}
   * @return XfR
   */
  @PatchMapping("/consumptions/{id}")
  public XfR patchUpdate(@RequestBody Consumption consumption,@PathVariable Long id) {
      Consumption upconsumption = consumptionServiceImpl.getById(id);
      if(upconsumption != null){
        upconsumption = ObjectCopyUtils.copyProperties(consumption,upconsumption,true);
      }
      return XfR.ok(consumptionServiceImpl.updateById(upconsumption));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/consumptions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(consumptionServiceImpl.removeById(id));
  }

  @PostMapping("/consumptions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "consumption");
     params.put("request", condition);

     return XfR.ok(consumptionServiceImpl.querys(params));
  }

}
