package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.CostAllocation;
import com.xforceplus.studyweikai.service.ICostAllocationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-01
 */
@RestController
public class CostAllocationController {

  @Autowired
  private ICostAllocationService costAllocationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param costAllocation ${table.comment}
   * @return
   */
  @GetMapping("/costallocations" )
  public XfR getCostAllocations(XfPage page, CostAllocation costAllocation) {
    return XfR.ok(costAllocationServiceImpl.page(page, Wrappers.query(costAllocation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/costallocations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costAllocationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param costAllocation ${table.comment}
   * @return XfR
   */
  @PostMapping("/costallocations")
  public XfR save(@RequestBody CostAllocation costAllocation) {
     return XfR.ok(costAllocationServiceImpl.save(costAllocation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param costAllocation ${table.comment}
   * @return XfR
   */
  @PutMapping("/costallocations/{id}")
  public XfR putUpdate(@RequestBody CostAllocation costAllocation,@PathVariable Long id) {
      costAllocation.setId(id);
      return XfR.ok(costAllocationServiceImpl.updateById(costAllocation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param costAllocation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/costallocations/{id}")
  public XfR patchUpdate(@RequestBody CostAllocation costAllocation,@PathVariable Long id) {
      CostAllocation upcostAllocation = costAllocationServiceImpl.getById(id);
      if(upcostAllocation != null){
        upcostAllocation = ObjectCopyUtils.copyProperties(costAllocation,upcostAllocation,true);
      }
      return XfR.ok(costAllocationServiceImpl.updateById(upcostAllocation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costallocations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costAllocationServiceImpl.removeById(id));
  }

  @PostMapping("/costallocations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cost_allocation");
     params.put("request", condition);

     return XfR.ok(costAllocationServiceImpl.querys(params));
  }

}
