package com.xforceplus.studyweikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyweikai.entity.ProductCostBasicInfo;
import com.xforceplus.studyweikai.service.IProductCostBasicInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-01
 */
@RestController
public class ProductCostBasicInfoController {

  @Autowired
  private IProductCostBasicInfoService productCostBasicInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productCostBasicInfo ${table.comment}
   * @return
   */
  @GetMapping("/productcostbasicinfos" )
  public XfR getProductCostBasicInfos(XfPage page, ProductCostBasicInfo productCostBasicInfo) {
    return XfR.ok(productCostBasicInfoServiceImpl.page(page, Wrappers.query(productCostBasicInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productcostbasicinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productCostBasicInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productCostBasicInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/productcostbasicinfos")
  public XfR save(@RequestBody ProductCostBasicInfo productCostBasicInfo) {
     return XfR.ok(productCostBasicInfoServiceImpl.save(productCostBasicInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productCostBasicInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/productcostbasicinfos/{id}")
  public XfR putUpdate(@RequestBody ProductCostBasicInfo productCostBasicInfo,@PathVariable Long id) {
      productCostBasicInfo.setId(id);
      return XfR.ok(productCostBasicInfoServiceImpl.updateById(productCostBasicInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productCostBasicInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productcostbasicinfos/{id}")
  public XfR patchUpdate(@RequestBody ProductCostBasicInfo productCostBasicInfo,@PathVariable Long id) {
      ProductCostBasicInfo upproductCostBasicInfo = productCostBasicInfoServiceImpl.getById(id);
      if(upproductCostBasicInfo != null){
        upproductCostBasicInfo = ObjectCopyUtils.copyProperties(productCostBasicInfo,upproductCostBasicInfo,true);
      }
      return XfR.ok(productCostBasicInfoServiceImpl.updateById(upproductCostBasicInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productcostbasicinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productCostBasicInfoServiceImpl.removeById(id));
  }

  @PostMapping("/productcostbasicinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_cost_basic_info");
     params.put("request", condition);

     return XfR.ok(productCostBasicInfoServiceImpl.querys(params));
  }

}
