package com.xforceplus.studyzhaiyuguo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhaiyuguo.entity.Qd;
import com.xforceplus.studyzhaiyuguo.service.IQdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-22
 */
@RestController
public class QdController {

  @Autowired
  private IQdService qdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param qd ${table.comment}
   * @return
   */
  @GetMapping("/qds" )
  public XfR getQds(XfPage page, Qd qd) {
    return XfR.ok(qdServiceImpl.page(page, Wrappers.query(qd)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/qds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(qdServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param qd ${table.comment}
   * @return XfR
   */
  @PostMapping("/qds")
  public XfR save(@RequestBody Qd qd) {
     return XfR.ok(qdServiceImpl.save(qd));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param qd ${table.comment}
   * @return XfR
   */
  @PutMapping("/qds/{id}")
  public XfR putUpdate(@RequestBody Qd qd,@PathVariable Long id) {
      qd.setId(id);
      return XfR.ok(qdServiceImpl.updateById(qd));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param qd ${table.comment}
   * @return XfR
   */
  @PatchMapping("/qds/{id}")
  public XfR patchUpdate(@RequestBody Qd qd,@PathVariable Long id) {
      Qd upqd = qdServiceImpl.getById(id);
      if(upqd != null){
        upqd = ObjectCopyUtils.copyProperties(qd,upqd,true);
      }
      return XfR.ok(qdServiceImpl.updateById(upqd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/qds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(qdServiceImpl.removeById(id));
  }

  @PostMapping("/qds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "qd");
     params.put("request", condition);

     return XfR.ok(qdServiceImpl.querys(params));
  }

}
