package com.xforceplus.studyzhaiyuguo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhaiyuguo.entity.Qdmx;
import com.xforceplus.studyzhaiyuguo.service.IQdmxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-22
 */
@RestController
public class QdmxController {

  @Autowired
  private IQdmxService qdmxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param qdmx ${table.comment}
   * @return
   */
  @GetMapping("/qdmxs" )
  public XfR getQdmxs(XfPage page, Qdmx qdmx) {
    return XfR.ok(qdmxServiceImpl.page(page, Wrappers.query(qdmx)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/qdmxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(qdmxServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param qdmx ${table.comment}
   * @return XfR
   */
  @PostMapping("/qdmxs")
  public XfR save(@RequestBody Qdmx qdmx) {
     return XfR.ok(qdmxServiceImpl.save(qdmx));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param qdmx ${table.comment}
   * @return XfR
   */
  @PutMapping("/qdmxs/{id}")
  public XfR putUpdate(@RequestBody Qdmx qdmx,@PathVariable Long id) {
      qdmx.setId(id);
      return XfR.ok(qdmxServiceImpl.updateById(qdmx));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param qdmx ${table.comment}
   * @return XfR
   */
  @PatchMapping("/qdmxs/{id}")
  public XfR patchUpdate(@RequestBody Qdmx qdmx,@PathVariable Long id) {
      Qdmx upqdmx = qdmxServiceImpl.getById(id);
      if(upqdmx != null){
        upqdmx = ObjectCopyUtils.copyProperties(qdmx,upqdmx,true);
      }
      return XfR.ok(qdmxServiceImpl.updateById(upqdmx));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/qdmxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(qdmxServiceImpl.removeById(id));
  }

  @PostMapping("/qdmxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "qdmx");
     params.put("request", condition);

     return XfR.ok(qdmxServiceImpl.querys(params));
  }

}
