package com.xforceplus.studyzhaiyuguo.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhaiyuguo.entity.Qdpp;
import com.xforceplus.studyzhaiyuguo.service.IQdppService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-22
 */
@RestController
public class QdppController {

  @Autowired
  private IQdppService qdppServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param qdpp ${table.comment}
   * @return
   */
  @GetMapping("/qdpps" )
  public XfR getQdpps(XfPage page, Qdpp qdpp) {
    return XfR.ok(qdppServiceImpl.page(page, Wrappers.query(qdpp)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/qdpps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(qdppServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param qdpp ${table.comment}
   * @return XfR
   */
  @PostMapping("/qdpps")
  public XfR save(@RequestBody Qdpp qdpp) {
     return XfR.ok(qdppServiceImpl.save(qdpp));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param qdpp ${table.comment}
   * @return XfR
   */
  @PutMapping("/qdpps/{id}")
  public XfR putUpdate(@RequestBody Qdpp qdpp,@PathVariable Long id) {
      qdpp.setId(id);
      return XfR.ok(qdppServiceImpl.updateById(qdpp));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param qdpp ${table.comment}
   * @return XfR
   */
  @PatchMapping("/qdpps/{id}")
  public XfR patchUpdate(@RequestBody Qdpp qdpp,@PathVariable Long id) {
      Qdpp upqdpp = qdppServiceImpl.getById(id);
      if(upqdpp != null){
        upqdpp = ObjectCopyUtils.copyProperties(qdpp,upqdpp,true);
      }
      return XfR.ok(qdppServiceImpl.updateById(upqdpp));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/qdpps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(qdppServiceImpl.removeById(id));
  }

  @PostMapping("/qdpps/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "qdpp");
     params.put("request", condition);

     return XfR.ok(qdppServiceImpl.querys(params));
  }

}
