package com.xforceplus.studyzhangxiaofeng.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhangxiaofeng.entity.Logistic;
import com.xforceplus.studyzhangxiaofeng.service.ILogisticService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-10
 */
@RestController
public class LogisticController {

  @Autowired
  private ILogisticService logisticServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param logistic ${table.comment}
   * @return
   */
  @GetMapping("/logistics" )
  public XfR getLogistics(XfPage page, Logistic logistic) {
    return XfR.ok(logisticServiceImpl.page(page, Wrappers.query(logistic)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/logistics/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(logisticServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param logistic ${table.comment}
   * @return XfR
   */
  @PostMapping("/logistics")
  public XfR save(@RequestBody Logistic logistic) {
     return XfR.ok(logisticServiceImpl.save(logistic));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param logistic ${table.comment}
   * @return XfR
   */
  @PutMapping("/logistics/{id}")
  public XfR putUpdate(@RequestBody Logistic logistic,@PathVariable Long id) {
      logistic.setId(id);
      return XfR.ok(logisticServiceImpl.updateById(logistic));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param logistic ${table.comment}
   * @return XfR
   */
  @PatchMapping("/logistics/{id}")
  public XfR patchUpdate(@RequestBody Logistic logistic,@PathVariable Long id) {
      Logistic uplogistic = logisticServiceImpl.getById(id);
      if(uplogistic != null){
        uplogistic = ObjectCopyUtils.copyProperties(logistic,uplogistic,true);
      }
      return XfR.ok(logisticServiceImpl.updateById(uplogistic));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/logistics/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(logisticServiceImpl.removeById(id));
  }

  @PostMapping("/logistics/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "logistic");
     params.put("request", condition);

     return XfR.ok(logisticServiceImpl.querys(params));
  }

}
