package com.xforceplus.studyzhangxiaofeng.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhangxiaofeng.entity.OrderBillHead;
import com.xforceplus.studyzhangxiaofeng.service.IOrderBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-10
 */
@RestController
public class OrderBillHeadController {

  @Autowired
  private IOrderBillHeadService orderBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBillHead ${table.comment}
   * @return
   */
  @GetMapping("/orderbillheads" )
  public XfR getOrderBillHeads(XfPage page, OrderBillHead orderBillHead) {
    return XfR.ok(orderBillHeadServiceImpl.page(page, Wrappers.query(orderBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderbillheads")
  public XfR save(@RequestBody OrderBillHead orderBillHead) {
     return XfR.ok(orderBillHeadServiceImpl.save(orderBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderbillheads/{id}")
  public XfR putUpdate(@RequestBody OrderBillHead orderBillHead,@PathVariable Long id) {
      orderBillHead.setId(id);
      return XfR.ok(orderBillHeadServiceImpl.updateById(orderBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderbillheads/{id}")
  public XfR patchUpdate(@RequestBody OrderBillHead orderBillHead,@PathVariable Long id) {
      OrderBillHead uporderBillHead = orderBillHeadServiceImpl.getById(id);
      if(uporderBillHead != null){
        uporderBillHead = ObjectCopyUtils.copyProperties(orderBillHead,uporderBillHead,true);
      }
      return XfR.ok(orderBillHeadServiceImpl.updateById(uporderBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/orderbillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bill_head");
     params.put("request", condition);

     return XfR.ok(orderBillHeadServiceImpl.querys(params));
  }

}
