package com.xforceplus.studyzhangxiaofeng.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.studyzhangxiaofeng.entity.RedLetter;
import com.xforceplus.studyzhangxiaofeng.service.IRedLetterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-10
 */
@RestController
public class RedLetterController {

  @Autowired
  private IRedLetterService redLetterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param redLetter ${table.comment}
   * @return
   */
  @GetMapping("/redletters" )
  public XfR getRedLetters(XfPage page, RedLetter redLetter) {
    return XfR.ok(redLetterServiceImpl.page(page, Wrappers.query(redLetter)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/redletters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(redLetterServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param redLetter ${table.comment}
   * @return XfR
   */
  @PostMapping("/redletters")
  public XfR save(@RequestBody RedLetter redLetter) {
     return XfR.ok(redLetterServiceImpl.save(redLetter));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param redLetter ${table.comment}
   * @return XfR
   */
  @PutMapping("/redletters/{id}")
  public XfR putUpdate(@RequestBody RedLetter redLetter,@PathVariable Long id) {
      redLetter.setId(id);
      return XfR.ok(redLetterServiceImpl.updateById(redLetter));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param redLetter ${table.comment}
   * @return XfR
   */
  @PatchMapping("/redletters/{id}")
  public XfR patchUpdate(@RequestBody RedLetter redLetter,@PathVariable Long id) {
      RedLetter upredLetter = redLetterServiceImpl.getById(id);
      if(upredLetter != null){
        upredLetter = ObjectCopyUtils.copyProperties(redLetter,upredLetter,true);
      }
      return XfR.ok(redLetterServiceImpl.updateById(upredLetter));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/redletters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(redLetterServiceImpl.removeById(id));
  }

  @PostMapping("/redletters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "red_letter");
     params.put("request", condition);

     return XfR.ok(redLetterServiceImpl.querys(params));
  }

}
