package com.xforceplus.cooptest.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author wangzheng
 * @date 2020-07-09
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.cooptest.entity.Products;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "supplier")
public interface ProductsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/products/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param products ${table.comment}
   * @return R
   */
  @PostMapping("/products/add")
  public R save(@RequestBody Products products);

  /**
   * 修改${table.comment}
   * @param products ${table.comment}
   * @return R
   */
  @PostMapping("/products/update")
  public R updateById(@RequestBody Products products);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/products/del/{id}" )
  public R removeById(@PathVariable Long id);

}