package com.xforceplus.taxwarebananaservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-06-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.Firewall;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "taxware-banana-service")
public interface FirewallFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/firewall/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param firewall ${table.comment}
   * @return R
   */
  @PostMapping("/firewall/add")
  public R save(@RequestBody Firewall firewall);

  /**
   * 修改${table.comment}
   * @param firewall ${table.comment}
   * @return R
   */
  @PostMapping("/firewall/update")
  public R updateById(@RequestBody Firewall firewall);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/firewall/del/{id}" )
  public R removeById(@PathVariable Long id);

}