package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 领票策略
 * </p>
 *
 * @author ultraman
 * @since 2021-05-07
 */
public enum FetchingStrategyEnum {

    DIRECT("direct", "直连领票"),
    BY_TAX_DISK_COUNT("byTaxDiskCount", "均匀领票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FetchingStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FetchingStrategyEnum fromCode(String code){
        switch(code) {
            case "direct":
                return DIRECT;
            case "byTaxDiskCount":
                return BY_TAX_DISK_COUNT;
            default:
                return null;
        }
    }
}
