package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 负载模式
 * </p>
 *
 * @author ultraman
 * @since 2021-05-07
 */
public enum LoadModeEnum {

    BALANCE("balance", "负载均衡"),
    GREENCHANNEL("greenchannel", "绿色通道");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LoadModeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LoadModeEnum fromCode(String code){
        switch(code) {
            case "balance":
                return BALANCE;
            case "greenchannel":
                return GREENCHANNEL;
            default:
                return null;
        }
    }
}
